import funkin.game.PlayState;
import flixel.FlxG;
import hxvlc.flixel.FlxVideoSprite;

if (FlxG.save.data.midsongvids_toggle) {
	camGreen = new FlxCamera(0, 0, 960, 720);
	FlxG.cameras.add(camGreen, false);
	camGreen.bgColor = FlxColor.TRANSPARENT;
	camGreen.visible = false;
	//
	var ytpmv = new FlxVideoSprite(0, 0);
	ytpmv.autoPause = false;
	ytpmv.load(Assets.getPath(Paths.video("hedgehog_stew")));
}
//
var title = new FlxSprite().loadGraphic(Paths.image("stages/robotnik/snooping"));

title.antialiasing = true;
title.alpha = 0.001;
//
function create() {
	if (FlxG.save.data.midsongvids_toggle) {
		FlxG.cameras.remove(camHUD, false);
		FlxG.cameras.add(camHUD, false);
		ytpmv.bitmap.onFormatSetup.add(function() {
			ytpmv.cameras = [camGreen];
			ytpmv.scale.set(1.5, 1.5);
			ytpmv.updateHitbox();
		});
		add(ytpmv);
	}
}

function postCreate() {
	title.cameras = [camHUD2];
	title.screenCenter();
	add(title);
	lmao = [
		PlayState.instance.healthBar,
		PlayState.instance.healthBarBG,
		PlayState.instance.iconP1,
		PlayState.instance.iconP2,
		PlayState.instance.scoreTxt,
		PlayState.instance.accuracyTxt,
		PlayState.instance.missesTxt
	];
	camHUD.alpha = 0.001;

	for (recep in playerStrums.members) {
		origPlrRecepX.push(recep.x);
	}
	for (recep in cpuStrums.members) {
		origOppRecepX.push(recep.x);
	}
}

/**
 * All video variables should be declared in this array, otherwise the custom focus handler
 * won't happen, and weird behaviour might happen.
 */
var videosToHandle:Array<FlxVideoSprite> = [ytpmv];

function onSubstateOpen() {
	// check: should we be playing a video?
	// if yes: pause all videos that are visible (so playing)
	// otherwise: do nothing, the variables would be null anyway
	if (FlxG.save.data.midsongvids_toggle) {
		for (vid in videosToHandle) {
			if (vid.visible) {
				vid.pause();
			}
		}
	}
}

function onSubstateClose() {
	// check: should we be playing a video?
	// if yes: resume all videos that are visible (so playing)
	// otherwise: do nothing, the variables would be null anyway
	if (FlxG.save.data.midsongvids_toggle) {
		for (vid in videosToHandle) {
			if (vid.visible) {
				vid.resume();
			}
		}
	}
}

/** NOTE for: onFocusLost() | onFocus()
 * Since hxvlc.flixel.FlxVideo/FlxVideoSprite doesn't have an "isPlaying" variable, we
 * check if the video is visible instead. If it isn't, then the video shouldn't be
 * playing in the first place.								~ xavi. (thatoneidiotxav)
**/
function onFocusLost() {
	// check: should we be playing a video?
	// if yes: run other check
	if (FlxG.save.data.midsongvids_toggle) {
		// check: in unpaused gameplay?
		// if yes: pause video
		// otherwise: do nothing, videos should already be paused
		if (!paused) {
			for (vid in videosToHandle) {
				if (vid.visible) {
					vid.pause();
				}
			}
		}
	}
}

function onFocus() {
	// check: should we be playing a video?
	// if yes, run other check
	if (FlxG.save.data.midsongvids_toggle) {
		// check: in unpaused gameplay?
		if (!paused) {
			for (vid in videosToHandle) {
				if (vid.visible) {
					vid.resume();
				}
			}
		}
	}
}

var origPlrRecepX = [];
var origOppRecepX = [];

function beatHit(beat) {
	switch (beat) {
		case 16:
			FlxTween.tween(title, {alpha: 1}, (Conductor.stepCrochet / 1000) * 4);
		case 24:
			FlxTween.tween(title, {alpha: 0.001}, (Conductor.stepCrochet / 1000) * 4);
		case 32:
			FlxTween.tween(camHUD, {alpha: 1}, (Conductor.stepCrochet / 1000) * 4);
		case 224:
			if (FlxG.save.data.midsongvids_toggle) {
				ytpmv.play();
				camGreen.visible = true;
			}
			newRatingsRVisible = false;

			for (i in 0...playerStrums.members.length)
				FlxTween.tween(playerStrums.members[i], {x: origPlrRecepX[i] - 240}, (Conductor.crochet / 1000) * 3, {ease: FlxEase.quartOut});

			for (i in cpuStrums.members)
				i.x -= 500;
			for (i in lmao)
				i.visible = false;
		case 286:
			for (i in 0...playerStrums.members.length)
				FlxTween.tween(playerStrums.members[i], {x: origPlrRecepX[i]}, (Conductor.crochet / 1000) * 1.8, {ease: FlxEase.quartOut});

			for (i in 0...cpuStrums.members.length)
				FlxTween.tween(cpuStrums.members[i], {x: origOppRecepX[i]}, (Conductor.crochet / 1000) * 1.8, {ease: FlxEase.quartOut});

		case 288:
			if (FlxG.save.data.midsongvids_toggle) {
				remove(ytpmv);
				camGreen.visible = false;
			}
			newRatingsRVisible = true;
			for (i in lmao)
				i.visible = true;
	}
}
